\version "2.24.0"
\language "deutsch"

\paper {
  system-system-spacing = #'((basic-distance . 20))
  markup-system-spacing = #'((basic-distance . 23))
  left-margin = 1.5\cm
  line-width = 18.7\cm
  print-page-number = false
  top-margin = 10\mm
  bottom-margin = 5\mm
  %ragged-last-bottom=##f
}

% diacritice: ă â î ş ţ Ţ Ş Ă Î

\header {
  title = "Crucii Tale"
  subtitle = " "
  %poet = "Vasile Militaru (1885 - 1959)"
  %composer = \markup \center-column { "Călin Buzilă" \small "19 august 2013" }
  %arranger = "io"
  %meter = "Moderato"
  tagline=""
}

global = {
  \key g \major
  \partial 2
  \set Staff.midiInstrument = "clarinet"
}

womenWords = \lyricmode {
  Cru -- cii Ta -- le, __ Stă -- pâ -- ne, 
  şi sfân -- tă În -- vi -- e -- rea Ta o lă -- u -- dăm,
  o lă -- u -- dăm, o lă -- u -- dăm şi o mă -- rim!
  
  \once \override LyricText.self-alignment-X = #-1
  "Mărire Tatălui şi Fiului şi Sfântului    " 
  Duh. 
  \once \override LyricText.self-alignment-X = #-1
  "Şi acum şi pururea şi în vecii vecilor. A -" 
  min.
  Sfân -- tă În -- vi -- e -- rea Ta o lă -- u -- dăm,
  o lă -- u -- dăm, o lă -- u -- dăm şi o mă -- rim!
}


menWords = \lyricmode {
  Cru -- cii Ta -- le ne în -- chi -- năm, Stă -- pâ -- ne, 
  şi sfân -- tă În -- vi -- e -- rea Ta
  o lă -- u -- dăm şi o mă -- rim!
   \once \override LyricText.self-alignment-X = #-1
  "Mărire Tatălui şi Fiului şi Sfântului    " 
  Duh. 
  \once \override LyricText.self-alignment-X = #-1
  "Şi acum şi pururea şi în vecii vecilor. A -" 
  min.
  Sfân -- tă În -- vi -- e -- rea Ta 
  o lă -- u -- dăm şi o mă -- rim!
}
  
sopMusic = \relative c'' {
  h4 h c( h8 a) g2( g2 g4) g g( a8 h) a4. 
  g8 h4 h h h c h8( a) g4. 
  g8 g4 fis g4. h8 h4 a h d e e d c h2 a g2. h4\rest
  \bar ":|." \break
  \mark "Mărire Tatălui"
  \cadenzaOn
  g\breve \bar"|" a2 \bar"|" a\breve \bar"|" \break g2 \bar"|"
  %d\breve \bar"|" e2 \bar"|" e\breve \bar"|" \break d2 \bar"|"
  \cadenzaOff
  h4 h h h c h8( a) g4. 
  g8 g4 fis g4. h8 h4 a h d e e d c h2 a g2.
  \bar "|."
}

altMusic = \relative c'' {
  g4 g a( fis) g2( g2 g4) g4 g( fis) fis4. 
  g8 g4 g g g a fis g4.
  r8 r2 r4. g8 g4 fis g4 
  h c c h a g2 fis g2. h4\rest
  \hide g\breve fis2 fis\breve g2
  %h\breve c2 c\breve h2
  g4 g g g a fis g4.
  r8 r2 r4. g8 g4 fis g4 
  h c c h a g2 fis g2.
}

bassMusic = \relative c' {
  g4 g c,( d8 e) g4. d8 h4 d4 g4 g g( c,) d4. 
  g8 g4 fis e d c d8( e) g4.
  r8 r1 r2. g4 g g g c, d2 d <g g,>2. r4
  g\breve \bar"|" d2 \bar"|" d\breve \bar"|" g2
  %g\breve \bar"|" c,2 \bar"|" c\breve \bar"|" g'2
  g4 fis e d c d8( e) g4.
  r8 r1 r2. g4 g g g c, d2 d <g g,>2.
  
}

myScore = \new Score <<
  \new ChoirStaff <<
    \new Staff <<
     \new Voice { \voiceOne \global \sopMusic }
     \addlyrics { \womenWords }
     \new Voice { \voiceTwo \global \altMusic }
    >>
    \new Staff <<
     \clef bass
     \new Voice { \global \bassMusic }
     \addlyrics { \menWords }
    >>
    >>
>>

\score {
  \myScore
  \layout { }
}

midiOutput = \midi {
  \tempo 4 = 77
  \context { \Voice \remove "Dynamic_performer" }
}

\score {
  \unfoldRepeats
  \myScore
  \midi { \midiOutput }
}

\score {
  \unfoldRepeats
  \new Voice { \global \sopMusic }
  \midi { \midiOutput }
}

\score {
  \unfoldRepeats
  \new Voice { \global \altMusic }
  \midi { \midiOutput }
}

\score {
  \unfoldRepeats
  \new Voice { \global \bassMusic }
  \midi { \midiOutput }
}
